/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks.tile;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xreliquary.blocks.tile.TileEntityBase;
import xreliquary.compat.waila.provider.IWailaDataChangeIndicator;
import xreliquary.init.ModItems;
import xreliquary.util.InventoryHelper;
import xreliquary.util.WorldHelper;
import xreliquary.util.potions.PotionIngredient;
import xreliquary.util.potions.XRPotionHelper;

public class TileEntityMortar
extends TileEntityBase
implements IWailaDataChangeIndicator {
    private static final int PESTLE_USAGE_MAX = 5;
    private int pestleUsedCounter = 0;
    private boolean dataChanged = true;
    private long finishCoolDown;
    private ItemStackHandler items = new ItemStackHandler(3){

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.isItemValid(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        private boolean isItemValid(@Nonnull ItemStack ist) {
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).func_190926_b() || !this.getStackInSlot(i).func_77969_a(ist)) continue;
                return false;
            }
            return XRPotionHelper.isItemIngredient(ist) || XRPotionHelper.isItemEssence(ist);
        }

        protected void onContentsChanged(int slot) {
            TileEntityMortar.this.dataChanged = true;
            WorldHelper.notifyBlockUpdate(TileEntityMortar.this);
        }
    };

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.items.deserializeNBT(tag.func_74775_l("items"));
        this.pestleUsedCounter = tag.func_74765_d("pestleUsed");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("pestleUsed", (short)this.pestleUsedCounter);
        compound.func_74782_a("items", (NBTBase)this.items.serializeNBT());
        return compound;
    }

    public NonNullList<ItemStack> getItemStacks() {
        return InventoryHelper.getItemStacks((IItemHandler)this.items);
    }

    public boolean usePestle() {
        int itemCount = 0;
        ArrayList<PotionIngredient> potionIngredients = new ArrayList<PotionIngredient>();
        for (ItemStack item : this.getItemStacks()) {
            if (item.func_190926_b()) continue;
            ++itemCount;
            potionIngredients.add(XRPotionHelper.getIngredient(item));
        }
        if (itemCount > 1) {
            ++this.pestleUsedCounter;
            this.spawnPestleParticles();
        }
        if (this.pestleUsedCounter >= 5) {
            List<PotionEffect> resultEffects = XRPotionHelper.combineIngredients(potionIngredients);
            if (resultEffects.isEmpty()) {
                this.pestleUsedCounter = 0;
                for (int clearSlot = 0; clearSlot < this.items.getSlots(); ++clearSlot) {
                    if (this.items.getStackInSlot(clearSlot).func_190926_b()) continue;
                    if (!this.field_145850_b.field_72995_K) {
                        EntityItem itemEntity = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, this.items.getStackInSlot(clearSlot).func_77946_l());
                        this.field_145850_b.func_72838_d((Entity)itemEntity);
                    }
                    this.items.setStackInSlot(clearSlot, ItemStack.field_190927_a);
                }
            } else {
                for (int clearSlot = 0; clearSlot < this.items.getSlots(); ++clearSlot) {
                    this.items.setStackInSlot(clearSlot, ItemStack.field_190927_a);
                }
                this.pestleUsedCounter = 0;
                this.finishCoolDown = this.field_145850_b.func_82737_E() + 20L;
                if (this.field_145850_b.field_72995_K) {
                    return true;
                }
                ItemStack resultItem = new ItemStack((Item)ModItems.potionEssence, 1, 0);
                XRPotionHelper.addPotionEffectsToStack(resultItem, resultEffects);
                EntityItem itemEntity = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, resultItem);
                this.field_145850_b.func_72838_d((Entity)itemEntity);
            }
            this.func_70296_d();
            return true;
        }
        return false;
    }

    private void spawnPestleParticles() {
        this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.15, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0, 0.1, 0.0, new int[0]);
    }

    public boolean isInCooldown() {
        return this.field_145850_b.func_82737_E() < this.finishCoolDown;
    }

    @Override
    public boolean getDataChanged() {
        boolean ret = this.dataChanged;
        this.dataChanged = false;
        return ret;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.items;
        }
        return (T)super.getCapability(capability, facing);
    }
}

